# HTTP Status Code

HTTP 응답 상태 코드는 특정 HTTP 요청이 성공적으로 완료되었는지 여부를 나타낸다. IANA가 공식적으로 관리하고 있으며, 응답은 5개의 클래스로 분류된다.

- **1xx** (정보, Informational) : 요청을 받았으며 프로세스를 계속한다.
- **2xx** (성공, Successful): 요청을 성공적으로 받았으며 인식했고 수용하였다.
- **3xx** (리다이렉션, Redirection): 요청 완료를 위해 추가 작업 조치가 필요하다.
- **4xx** (클라이언트 오류, Client error): 요청의 문법이 잘못되었거나 요청을 처리할 수 없다.
- **5xx** (서버 오류, Server error): 서버가 명백히 유효한 요청에 대해 충족을 실패했다.

<br/>

### 100번대

| 상태코드 |     이름      |                                            의미                                             |
| :------: | :-----------: | :-----------------------------------------------------------------------------------------: |
|   100    |     계속      | 서버는 이 코드를 제공하여 요청의 첫 번째 부분을 받았으며 나머지를 기다리고 있음을 나타낸다. |
|   101    | 프로토콜 전환 |           요청자가 서버에 프로토콜 전환을 요청했으며 서버는 이를 승인하는 중이다.           |
|   102    |     처리      |                                              -                                              |

### 200번대

| 상태코드 |  이름  |                         의미                         |
| :------: | :----: | :--------------------------------------------------: |
|   200    |   OK   |       서버가 요청을 제대로 처리했다는 뜻이다.        |
|   201    | 작성됨 | 성공적으로 요청되었으며 서버가 새 리소스를 작성했다. |
|   202    | 허용됨 |    서버가 요청을 접수했지만 아직 처리하지 않았다.    |

### 300번대

| 상태코드 |     이름      |                                               의미                                               |
| :------: | :-----------: | :----------------------------------------------------------------------------------------------: |
|   300    | 여러 선택항목 |                          서버가 요청에 따라 여러 조치를 선택할 수 있다.                          |
|   301    |   영구 이동   |                          요청한 페이지를 새 위치로 영구적으로 이동했다.                          |
|   302    |   임시 이동   | 현재 서버가 다른 위치의 페이지로 요청에 응답하고 있지만 요청자는 원래 위치를 계속 사용해야 한다. |

### 400번대

| 상태코드 |    이름     |                      의미                      |
| :------: | :---------: | :--------------------------------------------: |
|   400    | Bad Request |     서버가 요청의 구문을 인식하지 못했다.      |
|   401    |  권한 없음  |           이 요청은 인증이 필요하다.           |
|   402    |  결제 필요  |          이 요청은 결제가 필요합니다.          |
|   403    |  Forbidden  |    서버가 요청을 거부하고 있다.(인증 실패)     |
|   404    |  Not Found  | 서버가 요청한 페이지(Resource)를 찾을 수 없다. |
|   409    |  Conflict   |  서버가 요청을 수행하는 중에 충돌이 발생했다.  |

### 500번대

| 상태코드 |          이름           |                                            의미                                            |
| :------: | :---------------------: | :----------------------------------------------------------------------------------------: |
|   500    |     내부 서버 오류      |                       서버에 오류가 발생하여 요청을 수행할 수 없다.                        |
|   501    |      구현되지 않음      |                         서버에 요청을 수행할 수 있는 기능이 없다.                          |
|   502    |       Bad Gateway       | 서버가 게이트웨이나 프록시 역할을 하고 있거나 또는 업스트림 서버에서 잘못된 응답을 받았다. |
|   503    | 서비스를 사용할 수 없음 |   서버가 오버로드되었거나 유지관리를 위해 다운되었기 때문에 현재 서버를 사용할 수 없다.    |

<br/>

---

## 출처

📄 https://developer.mozilla.org/en-US/docs/Web/HTTP/Status  
📄 http://www.iana.org/assignments/http-status-codes/http-status-codes.xhtml  
📄 https://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html
